#!/bin/sh

get_option_name () sed 's/\ \?=.*$//'

get_option_value () sed 's/^.*=\ \?//'

while read line; do
	if ! printf "$line\n" | grep -q '^#\|^$'; then
		option_name="$(echo "$line" | get_option_name)"
		option_regex="$(echo "$option_name" | sed 's,\.,\\.,g')"
		option_correct_val="$(echo "$line" | get_option_value)"
		find /etc/sysctl.d -type f -name '*.conf' -execdir grep -q "^$option_regex" \{\} \; \
			-print # -execdir sed "s/^$option_regex\( \?= \?[^$option_correct_val]\|\$\)/$option_regex = $option_correct_val/" \{\} \;
	fi
done < "$(dirname "$0")/ubuntu-modules/resources/sysctl-correct.conf"
