## SSH settings
Possibly add port 22 to firewall? (i.e. only accept local connections)

    sudo ufw allow from 202.54.1.5/29 to any port 22
## Check services
    systemctl list-unit-files
### Install bum for a graphical interface
    apt-get install bum
## Set home directory perm's
    for i in $(mawk -F: '$3 > 999 && $3 < 65534 {print $1}' /etc/passwd); do [ -d /home/${i} ] && chmod -R 750 /home/${i}; done
# Other things to try (not tested yet)
## Kernel hardening
    kernel.randomize_va_space=1
 
    # IP Spoofing protection
    net.ipv4.conf.all.rp_filter = 1
    net.ipv4.conf.default.rp_filter = 1
    
    # Ignore ICMP broadcast requests
    net.ipv4.icmp_echo_ignore_broadcasts = 1
    
    # Disable source packet routing
    net.ipv4.conf.all.accept_source_route = 0
    net.ipv6.conf.all.accept_source_route = 0
    net.ipv4.conf.default.accept_source_route = 0
    net.ipv6.conf.default.accept_source_route = 0
    
    # Ignore send redirects
    net.ipv4.conf.all.send_redirects = 0
    net.ipv4.conf.default.send_redirects = 0

    # Block SYN attacks
    net.ipv4.tcp_syncookies = 1
    net.ipv4.tcp_max_syn_backlog = 2048
    net.ipv4.tcp_synack_retries = 2
    net.ipv4.tcp_syn_retries = 5

    # Disable IP packet forwarding
    net.ipv4.ip_forward = 0
    
    # Log Martians
    net.ipv4.conf.all.log_martians = 1
    net.ipv4.icmp_ignore_bogus_error_responses = 1

    # Ignore ICMP redirects
    net.ipv4.conf.all.accept_redirects = 0
    net.ipv6.conf.all.accept_redirects = 0
    net.ipv4.conf.default.accept_redirects = 0 
    net.ipv6.conf.default.accept_redirects = 0
    
    # Ignore Directed pings
    net.ipv4.icmp_echo_ignore_all = 1

Then run: `sudo sysctl -p`
## Find world-writable files
    find /dir -xdev -type d \( -perm -0002 -a ! -perm -1000 \) -print
## Find no-user files
    find /dir -xdev \( -nouser -o -nogroup \) -print

## Find rootkits, backdoors, etc.
    sudo apt-get install chkrootkit rkhunter
    sudo chkrootkit
    sudo rkhunter --update
    sudo rkhunter --check

## Firefox privacy settings
Block pop-ups and Strict privacy settings.

## Look for anything fishy:
### /etc/pam.d/login
### /etc/pam.d/system-auth
### /etc/rc.local
### /etc/hosts

## Maybe set ssh_config settings?
```
Host *
Protocol 2
```

# Find NOPASSWD sudo users
    grep -R 'NOPASSWD' /etc/sudoers /etc/sudoers.d/

# FYI
* `useradd -m` Creates home folder
* `userdel -r` Deletes home folder
* Undeletable files
  * `lsattr` List attributes
  * `chattr` Modify attributes
