#!/bin/sh -e

MODE=
USER=
PASS=

USERS="$(mawk -F: ' $3 >= 1000 && $3 < 65534 {print $1}' /etc/passwd)"
ADMINS="$(mawk -F: '$1 == "sudo" {print $4}' /etc/group | tr ',' '\n')"

AUTH_USERS=
AUTH_ADMINS=

while read line; do
  case $line in
    *Administrators*) MODE="admin" ;;
    *Users*) MODE="user" ;;
    *password:*) PASS="$(echo $line | cut -d' ' -f2)"
      if grep -q "^$PASS\$" /usr/share/dict/words; then
        echo "Insecure password for user $USER."
      fi
      ;;
    *) USER="$(echo "$line" | sed 's/ (you)//')"
      if [ "$MODE" = "admin" ]; then
        AUTH_ADMINS="$AUTH_ADMINS $USER"
      fi
      AUTH_USERS="$AUTH_USERS $USER"
  esac
done

AUTH_ADMINS="$(echo "$AUTH_ADMINS" | tr ' ' '\n' | sed '/^$/d')"
AUTH_USERS="$(echo "$AUTH_USERS" | tr ' ' '\n' | sed '/^$/d')"

UNAUTH_ADMINS="$(echo "$ADMINS" | grep -vF "$AUTH_ADMINS")"
UNAUTH_USERS="$(echo "$USERS" | grep -vF "$AUTH_USERS")"

if [ "$UNAUTH_USERS" ]; then
  echo "Unauthorized users:"
  echo "$UNAUTH_USERS"
fi

if [ "$UNAUTH_ADMINS" ]; then
  echo "Unauthorized admins:"
  echo "$UNAUTH_ADMINS"
fi

if [ $(id -u) -ne 0 ]; then
  echo "Not root. Stopping after listing."
  exit 0
fi

is_yes () {
  case $1 in ([Yy]|[Yy][Ee][Ss]) return 0 ;; esac
  return 1
}

is_no () {
  case $1 in ([Nn]|[Nn][Oo]) return 0 ;; esac
  return 1
}

# TODO: Add quiet flag to prevent question. Imply -y? Add -y.
confirm () {
  read -p "$1" answer < /dev/tty
  ${2:-is_yes} "$answer"
}

if [ "$UNAUTH_ADMINS" ] && confirm "Remove unauthorized sudoers? [y/N] " is_yes; then
  for admin in $UNAUTH_ADMINS; do
    deluser $admin sudo
  done
fi

if [ "$UNAUTH_USERS" ] && confirm "Remove unauthorized users? [y/N] " is_yes; then
  for user in $UNAUTH_USERS; do
    userdel -r $user
  done
fi
